' Copyright (c) 2002 Extended Systems, Inc.  ALL RIGHTS RESERVED.
'
' SAMPLE CODE
'
' This sample code can be used, modified, or copied by the licensee as long as
' the modifications (or the new binary resulting from a copy or modification of
' this sample code) are used with Extended Systems' products. The sample code
' is not redistributable as sample code, but is redistributable as compiled
' and linked binary code. If the sample code is used, modified, or copied by
' the licensee, Extended Systems Inc. reserves the right to receive from the
' licensee, upon request, at no cost to Extended Systems Inc., the modifications.
'
' Extended Systems Inc. does not warrant that the operation of this software
' will meet your requirements or that the operation of the software will be
' uninterrupted, be error free, or that defects in software will be corrected.
' This software is provided "AS IS" without warranty of any kind. The entire
' risk as to the quality and performance of this software is with the purchaser.
' If this software proves defective or inadequate, purchaser assumes the entire
' cost of servicing or repair. No oral or written information or advice given
' by an Extended Systems Inc. representative shall create a warranty or in any
' way increase the scope of this warranty.

Imports System.Data.OleDb


Public Class StateInfo
   Public ConnID As Int32
   Public DataConnection As New OleDbConnection()
End Class


<ComClass(aep_procedures.ClassId, aep_procedures.InterfaceId, aep_procedures.EventsId)> _
Public Class aep_procedures

#Region "COM GUIDs"
    ' These  GUIDs provide the COM identity for this class
    ' and its COM interfaces. If you change them, existing
    ' clients will no longer be able to access the class.
    Public Const ClassId As String = "16881E53-7654-45CC-8879-B3A352042D95"
    Public Const InterfaceId As String = "F0F14533-1E6D-4C60-AC81-A1F862CE5F27"
    Public Const EventsId As String = "CE85ED3A-CE1B-4195-9BC9-6FF0CECA4330"
#End Region

   ' A creatable COM class must have a Public Sub New()
   ' with no parameters, otherwise, the class will not be
   ' registered in the COM registry and cannot be created
   ' via CreateObject.
   Public Sub New()
       MyBase.New()
   End Sub

   ' Declare a collection of objects that can be used to store state information
   Private Shared colClientInfo As New Collection()


   ' This is the AEP startup function.  This is called the first time an Advantage
   ' connection calls a procedure in this AEP module. It is called once for each
   ' Advantage connection that calls a procedure in this module.
   ' Do any per-connection initialization here. Use the ulConnectionID as a
   ' unique identifier for each connection.
   Public Function Startup(ByVal ulConnectionID As Int32, _
                           ByVal strUsername As String, _
                           ByVal strPassword As String) As Int32   ' do not change prototype
      Dim oStateInfo As New StateInfo()

      Try

         ' Store the connection ID
         oStateInfo.ConnID = ulConnectionID

         ' Get a connection this client can use in all AEP calls to this dll. This is not required,
         ' it is simply shown as an example of something you might want to store on a per-client
         ' basis (state information).
         oStateInfo.DataConnection.ConnectionString = "Provider=Advantage.OLEDB.1;Data Source = x:\data\aep_tutorial.add" & _
                                          ";User ID=" & strUsername & ";Password=" & strPassword & ";StoredProcedureConnection=TRUE"
         oStateInfo.DataConnection.Open()

         ' Place this client state info into our collection. Use a synclock, as there might be other
         ' threads accessing colClientInfo right now
         SyncLock colClientInfo
         colClientInfo.Add(oStateInfo, CStr(ulConnectionID))
         End SyncLock

      Catch Ex As Exception
         Startup = 1
      End Try

      Startup = 0

   End Function


   ' This is the AEP shutdown function.  This is called once for each Advantage
   ' connection that has called a procedure in this module, and is called when
   ' the connection is terminating.
   ' The prototype must be exactly as it is in the example.
   ' Do your per-connection clean-up here. Use the ulConnectionID as a
   ' unique identifier for each connection.
   Public Function Shutdown(ByVal ulConnectionID As Int32, _
                            ByVal strUsername As String, _
                            ByVal strPassword As String) As Int32
      Dim oStateInfo As StateInfo

      ' Get this clients state information before doing anything
      SyncLock colClientInfo
      oStateInfo = colClientInfo.Item(CStr(ulConnectionID))
      End SyncLock

      oStateInfo.DataConnection.Close()

      ' free the clients state information
      SyncLock colClientInfo
      colClientInfo.Remove(CStr(ulConnectionID))
      End SyncLock

      Shutdown = 0

   End Function



   ' This is a sample Advantage Extended Procedure
   Public Function MyProcedure(ByVal ulConnectionID As Int32, _
                               ByVal strUsername As String, _
                               ByVal strPassword As String, _
                               ByVal strProcname As String, _
                               ByVal ulRecNum As Int32, _
                               ByVal strInput As String, _
                               ByVal strOutput As String) As Int32  ' Do not change prototype
      Dim ParamConn As OleDbConnection
      Dim GetCommand As OleDbCommand
      Dim DataAdapter As OleDbDataAdapter
      Dim InputTable As DataTable
      Dim OutputTable As OleDbCommand
      Dim strConnStr As String
      Dim strInputName As String
      Dim strOutputName As String
      Dim oStateInfo As StateInfo
      Dim sql As String
      Dim i As Int32

      MyProcedure = 1

      Try

         ' Get this clients state information before doing anything
         SyncLock colClientInfo
         oStateInfo = colClientInfo.Item(CStr(ulConnectionID))
         End SyncLock

         ' create objects
         GetCommand = New OleDbCommand()
         DataAdapter = New OleDbDataAdapter()
         InputTable = New DataTable()

         ' Split up the tablename and path
         i = InStrRev(strInput, "\")
         strConnStr = Left(strInput, i - 1)
         strInputName = Right(strInput, Len(strInput) - i)
         strOutputName = Right(strOutput, Len(strOutput) - i)

         ' Get a connection used to read the parameters
         ParamConn = New OleDbConnection("Provider=Advantage.OLEDB.1;Data Source = " & strConnStr & _
                                         ";StoredProcedureConnection=TRUE")
         ParamConn.Open()

         ' The code commented out below shows how input parameters may be read
         '
         'GetCommand.CommandType = CommandType.TableDirect
         'GetCommand.CommandText = strInputName
         'GetCommand.Connection = ParamConn
         'DataAdapter.SelectCommand = GetCommand
         'DataAdapter.Fill(InputTable)
         'iID = InputTable.Rows(0).Item("empid")
         'strLastname = InputTable.Rows(0).Item("lastname")


         ' Do whatever you want here, this can either be the body of the AEP, or a call to a
         ' procedure or function that will do the work. Use the clients state information
         ' stored in oStateInfo to maintain state between multiple Advantage users calling
         ' your AEP functions


         ' The code commented out below shows how output parameters may be returned
         '
         'sql = "INSERT INTO """ & strOutputName & """ values( " & oStateInfo.DataTable1.Fields("empid").Value & _
         '      ", '" & oStateInfo.DataTable1.Fields("lastname").Value & "', '" & _
         '      oStateInfo.DataTable1.Fields("firstname").Value & "', " & _
         '      colClientInfo.Count & " )"
         'OutputTable = New OleDbCommand(sql)
         'OutputTable.Connection = ParamConn
         'OutputTable.ExecuteNonQuery()

      Catch Ex As Exception
         ' Handle any exceptions here. It's best to have one string output parameter in each
         ' procedure that can be used to return a string representation of any errors
         ' encountered during stored procedure execution (using Ex.ToString)
         MyProcedure = 1

      Finally
         ' Disconnect
         ParamConn.Close()
      End Try

      MyProcedure = 0

   End Function



End Class


